/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.EmptyPiece;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.ResourcePool;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class LineBreakIterator
implements PrintIterator {
    private static final int MIN_HEIGHT = 0;
    private static final int MIN_WIDTH = 1;
    private final int lineHeight;
    private boolean hasNext = true;

    LineBreakIterator(LineBreakPrint print, Device device, GC gc) {
        this(LineBreakIterator.calculateLineHeight(print, device, gc));
    }

    private LineBreakIterator(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    private static int calculateLineHeight(LineBreakPrint print, Device device, GC gc) {
        Font oldFont = gc.getFont();
        gc.setFont(ResourcePool.forDevice(device).getFont(print.font));
        int result = gc.getFontMetrics().getHeight();
        gc.setFont(oldFont);
        return result;
    }

    public Point minimumSize() {
        return new Point(1, 0);
    }

    public Point preferredSize() {
        return new Point(1, this.lineHeight);
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public PrintPiece next(int width, int height) {
        if (width < 1 || height < 0) {
            return null;
        }
        this.hasNext = false;
        return new EmptyPiece(new Point(width, Math.min(height, this.lineHeight)));
    }

    public PrintIterator copy() {
        return this.hasNext ? new LineBreakIterator(this.lineHeight) : this;
    }
}

