/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.CrlClient;
import com.itextpdf.text.pdf.OcspClient;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfStamperImp;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;

public class LtvVerification {
    private PdfStamperImp writer;
    private PdfReader reader;
    private AcroFields acroFields;
    private Map<PdfName, ValidationData> validated = new HashMap<PdfName, ValidationData>();
    private boolean used = false;

    LtvVerification(PdfStamper stp) {
        this.writer = (PdfStamperImp)stp.getWriter();
        this.reader = stp.getReader();
        this.acroFields = stp.getAcroFields();
    }

    public boolean addVerification(String signatureName, OcspClient ocsp, CrlClient crl, CertificateOption certOption, Level level, CertificateInclusion certInclude) throws Exception {
        if (this.used) {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("verification.already.output", new Object[0]));
        }
        PdfPKCS7 pk = this.acroFields.verifySignature(signatureName);
        Certificate[] xc = pk.getSignCertificateChain();
        ValidationData vd = new ValidationData();
        for (int k = 0; k < xc.length; ++k) {
            byte[] cim;
            byte[] ocspEnc = null;
            if (ocsp != null && level != Level.CRL && k < xc.length - 1 && (ocspEnc = ocsp.getEncoded((X509Certificate)xc[k], (X509Certificate)xc[k + 1], null)) != null) {
                vd.ocsps.add(LtvVerification.buildOCSPResponse(ocspEnc));
            }
            if (crl != null && (level == Level.CRL || level == Level.OCSP_CRL || level == Level.OCSP_OPTIONAL_CRL && ocspEnc == null) && (cim = crl.getEncoded((X509Certificate)xc[k], null)) != null) {
                boolean dup = false;
                for (byte[] b : vd.crls) {
                    if (!Arrays.equals(b, cim)) continue;
                    dup = true;
                    break;
                }
                if (!dup) {
                    vd.crls.add(cim);
                }
            }
            if (certOption == CertificateOption.SIGNING_CERTIFICATE) break;
        }
        if (vd.crls.isEmpty() && vd.ocsps.isEmpty()) {
            return false;
        }
        if (certInclude == CertificateInclusion.YES) {
            for (Certificate c : xc) {
                vd.certs.add(c.getEncoded());
            }
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    private static byte[] buildOCSPResponse(byte[] BasicOCSPResponse2) throws IOException {
        DEROctetString doctet = new DEROctetString(BasicOCSPResponse2);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add((DEREncodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        v2.add((DEREncodable)doctet);
        DEREnumerated den = new DEREnumerated(0);
        ASN1EncodableVector v3 = new ASN1EncodableVector();
        v3.add((DEREncodable)den);
        v3.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)new DERSequence(v2)));
        DERSequence seq = new DERSequence(v3);
        return seq.getEncoded();
    }

    private PdfName getSignatureHashKey(String signatureName) throws NoSuchAlgorithmException, IOException {
        PdfDictionary dic = this.acroFields.getSignatureDictionary(signatureName);
        PdfString contents = dic.getAsString(PdfName.CONTENTS);
        byte[] bc = contents.getOriginalBytes();
        byte[] bt = null;
        if (PdfName.ETSI_RFC3161.equals(PdfReader.getPdfObject(dic.get(PdfName.SUBFILTER)))) {
            ASN1InputStream din = new ASN1InputStream((InputStream)new ByteArrayInputStream(bc));
            DERObject pkcs = din.readObject();
            bc = pkcs.getEncoded();
        }
        bt = LtvVerification.hashBytesSha1(bc);
        return new PdfName(LtvVerification.convertToHex(bt));
    }

    private static String convertToHex(byte[] bt) {
        ByteBuffer buf = new ByteBuffer();
        for (byte b : bt) {
            buf.appendHex(b);
        }
        return PdfEncodings.convertToString(buf.toByteArray(), null).toUpperCase();
    }

    private static byte[] hashBytesSha1(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest sh = MessageDigest.getInstance("SHA1");
        return sh.digest(b);
    }

    void merge() throws IOException {
        if (this.used || this.validated.isEmpty()) {
            return;
        }
        this.used = true;
        PdfDictionary catalog = this.reader.getCatalog();
        PdfObject dss = catalog.get(PdfName.DSS);
        if (dss == null) {
            this.createDss();
        } else {
            this.updateDss();
        }
    }

    private void updateDss() throws IOException {
        PdfDictionary catalog = this.reader.getCatalog();
        this.writer.markUsed(catalog);
        PdfDictionary dss = catalog.getAsDict(PdfName.DSS);
        PdfArray ocsps = dss.getAsArray(PdfName.OCSPS);
        PdfArray crls = dss.getAsArray(PdfName.CRLS);
        PdfArray certs = dss.getAsArray(PdfName.CERTS);
        dss.remove(PdfName.OCSPS);
        dss.remove(PdfName.CRLS);
        dss.remove(PdfName.CERTS);
        PdfDictionary vrim = dss.getAsDict(PdfName.VRI);
        if (vrim != null) {
            for (PdfName n : vrim.getKeys()) {
                PdfDictionary vri;
                if (!this.validated.containsKey(n) || (vri = vrim.getAsDict(n)) == null) continue;
                LtvVerification.deleteOldReferences(ocsps, vri.getAsArray(PdfName.OCSP));
                LtvVerification.deleteOldReferences(crls, vri.getAsArray(PdfName.CRL));
                LtvVerification.deleteOldReferences(certs, vri.getAsArray(PdfName.CERT));
            }
        }
        if (ocsps == null) {
            ocsps = new PdfArray();
        }
        if (crls == null) {
            crls = new PdfArray();
        }
        if (certs == null) {
            certs = new PdfArray();
        }
        this.outputDss(dss, vrim, ocsps, crls, certs);
    }

    private static void deleteOldReferences(PdfArray all, PdfArray toDelete) {
        if (all == null || toDelete == null) {
            return;
        }
        for (PdfObject pi : toDelete) {
            if (!pi.isIndirect()) continue;
            PRIndirectReference pir = (PRIndirectReference)pi;
            for (int k = 0; k < all.size(); ++k) {
                PdfObject po = all.getPdfObject(k);
                if (!po.isIndirect()) continue;
                PRIndirectReference pod = (PRIndirectReference)po;
                if (pir.getNumber() != pod.getNumber()) continue;
                all.remove(k);
                --k;
            }
        }
    }

    private void createDss() throws IOException {
        this.outputDss(new PdfDictionary(), new PdfDictionary(), new PdfArray(), new PdfArray(), new PdfArray());
    }

    private void outputDss(PdfDictionary dss, PdfDictionary vrim, PdfArray ocsps, PdfArray crls, PdfArray certs) throws IOException {
        PdfDictionary catalog = this.reader.getCatalog();
        this.writer.markUsed(catalog);
        for (PdfName vkey : this.validated.keySet()) {
            PdfIndirectReference iref;
            PdfStream ps;
            PdfArray ocsp = new PdfArray();
            PdfArray crl = new PdfArray();
            PdfArray cert = new PdfArray();
            PdfDictionary vri = new PdfDictionary();
            for (byte[] b : this.validated.get((Object)vkey).crls) {
                ps = new PdfStream(b);
                ps.flateCompress();
                iref = this.writer.addToBody((PdfObject)ps, false).getIndirectReference();
                crl.add(iref);
                crls.add(iref);
            }
            for (byte[] b : this.validated.get((Object)vkey).ocsps) {
                ps = new PdfStream(b);
                ps.flateCompress();
                iref = this.writer.addToBody((PdfObject)ps, false).getIndirectReference();
                ocsp.add(iref);
                ocsps.add(iref);
            }
            for (byte[] b : this.validated.get((Object)vkey).certs) {
                ps = new PdfStream(b);
                ps.flateCompress();
                iref = this.writer.addToBody((PdfObject)ps, false).getIndirectReference();
                cert.add(iref);
                certs.add(iref);
            }
            if (ocsp.size() > 0) {
                vri.put(PdfName.OCSP, this.writer.addToBody((PdfObject)ocsp, false).getIndirectReference());
            }
            if (crl.size() > 0) {
                vri.put(PdfName.CRL, this.writer.addToBody((PdfObject)crl, false).getIndirectReference());
            }
            if (cert.size() > 0) {
                vri.put(PdfName.CERT, this.writer.addToBody((PdfObject)cert, false).getIndirectReference());
            }
            vrim.put(vkey, this.writer.addToBody((PdfObject)vri, false).getIndirectReference());
        }
        dss.put(PdfName.VRI, this.writer.addToBody((PdfObject)vrim, false).getIndirectReference());
        if (ocsps.size() > 0) {
            dss.put(PdfName.OCSPS, this.writer.addToBody((PdfObject)ocsps, false).getIndirectReference());
        }
        if (crls.size() > 0) {
            dss.put(PdfName.CRLS, this.writer.addToBody((PdfObject)crls, false).getIndirectReference());
        }
        if (certs.size() > 0) {
            dss.put(PdfName.CERTS, this.writer.addToBody((PdfObject)certs, false).getIndirectReference());
        }
        catalog.put(PdfName.DSS, this.writer.addToBody((PdfObject)dss, false).getIndirectReference());
    }

    private static class ValidationData {
        public List<byte[]> crls = new ArrayList<byte[]>();
        public List<byte[]> ocsps = new ArrayList<byte[]>();
        public List<byte[]> certs = new ArrayList<byte[]>();

        private ValidationData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateInclusion {
        YES,
        NO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateOption {
        SIGNING_CERTIFICATE,
        WHOLE_CHAIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OCSP,
        CRL,
        OCSP_CRL,
        OCSP_OPTIONAL_CRL;

    }
}

